/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.listeners;

import java.util.Optional;
import net.skinsrestorer.shared.interfaces.ISRPlugin;
import net.skinsrestorer.shared.listeners.LoginProfileEvent;
import net.skinsrestorer.shared.storage.Config;

public abstract class LoginProfileListener {
    protected boolean handleSync(LoginProfileEvent event) {
        return Config.DISABLE_ON_JOIN_SKINS || Config.NO_SKIN_IF_LOGIN_CANCELED && event.isCancelled();
    }

    protected Optional<String> handleAsync(LoginProfileEvent event) {
        ISRPlugin plugin = this.getPlugin();
        String playerName = event.getPlayerName();
        Optional<String> skin = plugin.getSkinStorage().getSkinOfPlayer(playerName);
        if (event.isOnline() && !skin.isPresent() && !Config.ALWAYS_APPLY_PREMIUM && !Config.DEFAULT_SKINS_PREMIUM) {
            return Optional.empty();
        }
        if (Config.DEFAULT_SKINS_ENABLED) {
            skin = Optional.ofNullable(plugin.getSkinStorage().getDefaultSkinName(playerName));
        }
        return Optional.of(skin.orElse(playerName));
    }

    protected abstract ISRPlugin getPlugin();
}

